<?php
// Ensure connection to database
require_once 'connection.php';

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve form data
    $groupId = $_POST['groupId'];
    $senderEmail = $_POST['senderEmail'];
    $messageContent = $_POST['messageContent'];
    $messageType = $_POST['messageType'];

    // Prepare SQL statement to insert data into groupmessagetable
    $sql = "INSERT INTO groupmessagetable (groupId, senderEmail, messageContent, messageType) 
            VALUES (?, ?, ?, ?)";
    
    // Use prepared statement to prevent SQL injection
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssss", $groupId, $senderEmail, $messageContent, $messageType);

    // Execute the statement
    if ($stmt->execute()) {
        echo "Data inserted successfully.";
    } else {
        echo "Error: " . $stmt->error;
    }

    // Close statement and connection
    $stmt->close();
    $conn->close();
}
?>
