<?php
// Include the database connection file
require_once 'connection.php';

// Check if 'blocked_by' parameter is present in the query string
if (isset($_POST['blocked_by'])) {
    // Escape user input for security
    $blocked_by = $conn->real_escape_string($_POST['blocked_by']);

    // Query to fetch blocked users' profiles
    $blocked_sql = "SELECT u.name, u.email, u.image
                    FROM blockedtable AS b
                    JOIN user AS u ON b.userBlocked = u.email
                    WHERE b.blockedBy = '$blocked_by'";

    $blocked_result = $conn->query($blocked_sql);

    // Prepare an array to hold the results
    $response = array();

    if ($blocked_result->num_rows > 0) {
        // Iterate over each row and add to the response array
        while ($row = $blocked_result->fetch_assoc()) {
            $blocked_user = array(
                'name' => $row['name'],
                'email' => $row['email'],
                'image' => $row['image']
            );
            $response[] = $blocked_user;
        }
    }

    // Output the JSON response
    header('Content-Type: application/json');
    echo json_encode($response);
} else {
    // Handle missing 'blocked_by' parameter
    echo json_encode(array('error' => 'Missing parameter: blocked_by'));
}

$conn->close();
?>
