<?php
// Ensure connection to database
require_once 'connection.php';

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve form data
    $postedSender = $_POST['sender_email'];
    $postedReceiverEmail = $_POST['receiver_email'];

    // Prepare SQL statement to delete data from chat table
    $sql = "DELETE FROM chat 
            WHERE (sender_email = ? AND receiver_email = ?) 
            OR (sender_email = ? AND receiver_email = ?)";

    // Use prepared statement to prevent SQL injection
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssss", $postedSender, $postedReceiverEmail, $postedReceiverEmail, $postedSender);

    // Execute the statement
    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo "Messages deleted successfully.";
        } else {
            echo "No messages found to delete.";
        }
    } else {
        echo "Error: " . $stmt->error;
    }

    // Close statement and connection
    $stmt->close();
    $conn->close();
}
?>
